using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;

namespace IndianHealthService.BMXNet.Tools.SchemaBuilder
{
	/// <summary>
	/// Summary description for DSelectSchema.
	/// </summary>
	public class DSelectSchema : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel pnlPageBottom;
		private System.Windows.Forms.Button cmdCancel;
        private System.Windows.Forms.Button cmdOK;
        private ListBox lstSchemas;
        private Panel pnlSchemas;
        private Label lblDescriptionResourceGroup;
		private System.ComponentModel.Container components = null;

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.pnlPageBottom = new System.Windows.Forms.Panel();
            this.cmdCancel = new System.Windows.Forms.Button();
            this.cmdOK = new System.Windows.Forms.Button();
            this.lstSchemas = new System.Windows.Forms.ListBox();
            this.pnlSchemas = new System.Windows.Forms.Panel();
            this.lblDescriptionResourceGroup = new System.Windows.Forms.Label();
            this.pnlPageBottom.SuspendLayout();
            this.pnlSchemas.SuspendLayout();
            this.SuspendLayout();
            // 
            // pnlPageBottom
            // 
            this.pnlPageBottom.Controls.Add(this.cmdCancel);
            this.pnlPageBottom.Controls.Add(this.cmdOK);
            this.pnlPageBottom.Location = new System.Drawing.Point(0, 209);
            this.pnlPageBottom.Name = "pnlPageBottom";
            this.pnlPageBottom.Size = new System.Drawing.Size(416, 40);
            this.pnlPageBottom.TabIndex = 6;
            // 
            // cmdCancel
            // 
            this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.cmdCancel.Location = new System.Drawing.Point(326, 8);
            this.cmdCancel.Name = "cmdCancel";
            this.cmdCancel.Size = new System.Drawing.Size(66, 24);
            this.cmdCancel.TabIndex = 2;
            this.cmdCancel.Text = "Cancel";
            // 
            // cmdOK
            // 
            this.cmdOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.cmdOK.Location = new System.Drawing.Point(254, 8);
            this.cmdOK.Name = "cmdOK";
            this.cmdOK.Size = new System.Drawing.Size(66, 24);
            this.cmdOK.TabIndex = 1;
            this.cmdOK.Text = "OK";
            this.cmdOK.Click += new System.EventHandler(this.cmdOK_Click);
            // 
            // lstSchemas
            // 
            this.lstSchemas.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.lstSchemas.Location = new System.Drawing.Point(6, 24);
            this.lstSchemas.Name = "lstSchemas";
            this.lstSchemas.Size = new System.Drawing.Size(407, 173);
            this.lstSchemas.TabIndex = 0;
            // 
            // pnlSchemas
            // 
            this.pnlSchemas.Controls.Add(this.lblDescriptionResourceGroup);
            this.pnlSchemas.Controls.Add(this.lstSchemas);
            this.pnlSchemas.Location = new System.Drawing.Point(0, 0);
            this.pnlSchemas.Name = "pnlSchemas";
            this.pnlSchemas.Size = new System.Drawing.Size(416, 206);
            this.pnlSchemas.TabIndex = 8;
            // 
            // lblDescriptionResourceGroup
            // 
            this.lblDescriptionResourceGroup.AutoSize = true;
            this.lblDescriptionResourceGroup.Location = new System.Drawing.Point(3, 8);
            this.lblDescriptionResourceGroup.Name = "lblDescriptionResourceGroup";
            this.lblDescriptionResourceGroup.Size = new System.Drawing.Size(130, 13);
            this.lblDescriptionResourceGroup.TabIndex = 4;
            this.lblDescriptionResourceGroup.Text = "Schemas Stored in RPMS";
            // 
            // DSelectSchema
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(416, 249);
            this.ControlBox = false;
            this.Controls.Add(this.pnlSchemas);
            this.Controls.Add(this.pnlPageBottom);
            this.Name = "DSelectSchema";
            this.Text = "Select Schema";
            this.Load += new System.EventHandler(this.DSelectSchema_Load);
            this.pnlPageBottom.ResumeLayout(false);
            this.pnlSchemas.ResumeLayout(false);
            this.pnlSchemas.PerformLayout();
            this.ResumeLayout(false);

		}
		#endregion

		#region Fields

		private string		m_sSchemaName;
		private double		m_nSchemaIEN;
		private double		m_nFileNumber;
		private DataTable	m_dtSchemas;

		#endregion Fields

		#region Properties
		public double FileNumber
		{
			get
			{
				return m_nFileNumber;
			}
			set
			{
				m_nFileNumber = value;
			}
		}

		public double SchemaIEN
		{
			get
			{
				return m_nSchemaIEN;
			}
			set
			{
				m_nSchemaIEN = value;
			}
		}

		public string SchemaName
		{
			get
			{
				return m_sSchemaName;
			}
			set
			{
				m_sSchemaName = value;
			}
		}
		#endregion Properties

		#region Methods

        private RemoteSession _remoteSession = null;

        public RemoteSession RemoteSession
        {
            get { return _remoteSession; }
            set { _remoteSession = value; }
        }



		private void UpdateDialogData(bool b)
		{
			if (b == true) //Move data to dialog controls from member variables
			{
			}
			else //Move data to member variables from dialog controls
			{
			}
		}

		private void cmdOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				DataView dv = new DataView(m_dtSchemas);
				dv.Sort = "BMXIEN ASC";

				double nIen = (double) lstSchemas.SelectedValue;
				DataRowView[] drv = dv.FindRows(nIen);
			
				Debug.Assert(drv.Length == 1);

				DataRow dr = drv[0].Row;

				m_nSchemaIEN = nIen;
				m_sSchemaName = dr["SCHEMA"].ToString();
				m_nFileNumber = Convert.ToDouble(dr["FILE OR SUBFILE NUMBER"]);
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message, "BMX Schema Builder");

			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		public DSelectSchema()
		{
			InitializeComponent();
		}
		#endregion Methods

        private void DSelectSchema_Load(object sender, EventArgs e)
        {

        }

        private void lblDescriptionResourceGroup_Click(object sender, EventArgs e)
        {

        }


        internal void InitializePage(RemoteSession remoteSession)
        {
            this.RemoteSession = remoteSession;
            m_dtSchemas = this.RemoteSession.TableFromCommand("BMX ADO SS^SCHEMAS^^B~~~9999");
            m_dtSchemas.TableName = "SCHEMAS";
            lstSchemas.DisplayMember = "SCHEMA";
            lstSchemas.ValueMember = "BMXIEN";
            lstSchemas.DataSource = m_dtSchemas;
           
        }
    }
}
